<?php

namespace App\Http\Controllers;

use Artisan;
use Illuminate\Http\Request;
use App\Models\PaymentGateway;

class UpdateController extends Controller
{
    public function version()
    {
        return view('updater.version');
    }

    public function recurse_copy($src, $dst)
    {
        // dd(base_path($src), base_path($dst));
        $dir = opendir(base_path($src));
        @mkdir(base_path($dst), 0775, true);
        while (false !== ($file = readdir($dir))) {
            if ($file != '.' && $file != '..') {
                if (is_dir(base_path($src) . '/' . $file)) {
                    $this->recurse_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    copy(base_path($src . '/' . $file), base_path($dst) . '/' . $file);
                }
            }
        }
        closedir($dir);
    }

    public function upversion(Request $request)
    {
        $assets = [
            ['path' => 'app', 'type' => 'folder', 'action' => 'replace'], 
            ['path' => 'assets/front/multipurpose/datepickerJs', 'type' => 'folder', 'action' => 'add'], 
            ['path' => 'assets/front/bakery/assets/css/theme-dark.css', 'type' => 'file', 'action' => 'replace'],
            ['path' => 'assets/front/css/qr-menu.css', 'type' => 'file', 'action' => 'replace'],
            ['path' => 'database/migrations', 'type' => 'folder', 'action' => 'replace'],
            ['path' => 'resources/views', 'type' => 'folder', 'action' => 'replace'],
            ['path' => 'routes', 'type' => 'folder', 'action' => 'replace'], 
            ['path' => 'version.json', 'type' => 'file', 'action' => 'replace']
        ];

        foreach ($assets as $key => $asset) {
            $des = '';
            if (strpos($asset['path'], 'assets/') !== false) {
                $des = 'public/' . $asset['path'];
            } else {
                $des = $asset['path'];
            }
            // if updater need to replace files / folder (with/without content)
            if ($asset['action'] == 'replace') {
                if ($asset['type'] == 'file') {
                    copy(base_path('public/updater/' . $asset['path']), base_path($des));
                }
                if ($asset['type'] == 'folder') {
                    $this->delete_directory(base_path($des));
                    $this->recurse_copy('public/updater/' . $asset['path'], $des);
                }
            } elseif ($asset['action'] == 'add') {
                if ($asset['type'] == 'folder') {
                    $this->recurse_copy('public/updater/' . $asset['path'], $des);
                }
                if ($asset['type'] == 'file') {
                    copy(base_path('public/updater/' . $asset['path']), base_path($des));
                }
            }
        }
    
        // Artisan::call('config:clear');
         Artisan::call('migrate');
        \Session::flash('success', 'Updated successfully');
        return redirect('updater/success.php');
    }

    function delete_directory($dirname)
    {
        $dir_handle = null;
        if (is_dir($dirname)) {
            $dir_handle = opendir($dirname);
        }
        if (!$dir_handle) {
            return false;
        }
        while ($file = readdir($dir_handle)) {
            if ($file != '.' && $file != '..') {
                if (!is_dir($dirname . '/' . $file)) {
                    unlink($dirname . '/' . $file);
                } else {
                    $this->delete_directory($dirname . '/' . $file);
                }
            }
        }
        closedir($dir_handle);
        rmdir($dirname);
        return true;
    }


    // public function redirectToWebsite(Request $request) {
    //     $arr = ['WEBSITE_HOST' => $request->website_host];
    //     setEnvironmentValue($arr);
    //     \Artisan::call('config:clear');
    //     return redirect()->route('front.index');
    // }
}
