<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\BasicExtended;
use App\Models\Slider;
use App\Models\Language;
use Validator;
use Session;

class SliderController extends Controller
{
    public function index(Request $request)
    {
        $lang = Language::where('code', $request->language)->first();

        $lang_id = $lang->id;
        $data['sliders'] = Slider::where('language_id', $lang_id)->orderBy('id', 'DESC')->get();


        $data['abe'] = $lang->basic_extended;


        $data['lang_id'] = $lang_id;
        return view('admin.home.hero.slider.index', $data);
    }

    public function edit($id)
    {
        $data['slider'] = Slider::findOrFail($id);
        return view('admin.home.hero.slider.edit', $data);
    }


    public function store(Request $request)
    {
        $m_image = $request->file('main_image');
        $bg_img = $request->file('bg_image');

        $allowedExts = array('jpg', 'png', 'jpeg');

        $rules = [
            'language_id' => 'required',
            'title' => 'required|max:255',
            'title_font_size' => 'required|numeric|digits_between:1,3',
            'text' => 'required|max:255',
            'text_font_size' => 'required|numeric|digits_between:1,3',
            'button_text_font_size' => 'required|numeric|digits_between:1,3',
            'button_text1_font_size' => 'required|numeric|digits_between:1,3',
            'serial_number' => 'required|integer',

            'main_image' => [
                function ($attribute, $value, $fail) use ($m_image, $allowedExts) {
                    if (!empty($m_image)) {
                        $ext = $m_image->getClientOriginalExtension();
                        if (!in_array($ext, $allowedExts)) {
                            return $fail("Only png, jpg, jpeg image is allowed");
                        }
                    }
                },
            ],

            'bg_image' => [
                function ($attribute, $value, $fail) use ($bg_img, $allowedExts) {
                    if (!empty($bg_img)) {
                        $ext = $bg_img->getClientOriginalExtension();
                        if (!in_array($ext, $allowedExts)) {
                            return $fail("Only png, jpg, jpeg image is allowed");
                        }
                    }
                },
            ],

        ];

        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            $errmsgs = $validator->getMessageBag()->add('error', 'true');
            return response()->json($validator->errors());
        }

        $input = $request->all();

        if ($request->hasFile('main_image')) {
            $main_image = time() . '.' . $m_image->getClientOriginalExtension();
            $request->file('main_image')->move(public_path('assets/front/img/sliders/'), $main_image);
            $input['image'] = $main_image;
        }

        if ($request->hasFile('bg_image')) {
            $bg_image = time() . '.' . $bg_img->getClientOriginalExtension();
            $request->file('bg_image')->move(public_path('assets/front/img/sliders/bg_image/'), $bg_image);
            $input['bg_image'] = $bg_image;
        }



        $slider = new Slider;
        $slider->create($input);

        Session::flash('success', 'Slider added successfully!');
        return "success";
    }

    public function update(Request $request)
    {
        $m_image = $request->file('main_image');
        $bg_img = $request->file('bg_image');
        $allowedExts = array('jpg', 'png', 'jpeg');

        $rules = [
            'title' => 'required|max:255',
            'title_font_size' => 'required|numeric|digits_between:1,3',
            'text' => 'required|max:255',
            'text_font_size' => 'required|numeric|digits_between:1,3',
            'button_text_font_size' => 'required|numeric|digits_between:1,3',
            'button_text1_font_size' => 'required|numeric|digits_between:1,3',
            'serial_number' => 'required|integer',

            'main_image' => [
                function ($attribute, $value, $fail) use ($m_image, $allowedExts) {
                    if (!empty($m_image)) {
                        $ext = $m_image->getClientOriginalExtension();
                        if (!in_array($ext, $allowedExts)) {
                            return $fail("Only png, jpg, jpeg image is allowed");
                        }
                    }
                },
            ],

            'bg_image' => [
                function ($attribute, $value, $fail) use ($bg_img, $allowedExts) {
                    if (!empty($bg_img)) {
                        $ext = $bg_img->getClientOriginalExtension();
                        if (!in_array($ext, $allowedExts)) {
                            return $fail("Only png, jpg, jpeg image is allowed");
                        }
                    }
                },
            ],

        ];

        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            $errmsgs = $validator->getMessageBag()->add('error', 'true');
            return response()->json($validator->errors());
        }

        $input = $request->all();

        $slider = Slider::findOrFail($request->slider_id);

        if ($request->hasFile('main_image')) {
            $main_image = time() . '.' . $m_image->getClientOriginalExtension();
            $request->file('main_image')->move(public_path('assets/front/img/sliders/'), $main_image);
                @unlink(public_path('assets/front/img/sliders/' . $slider->image));
            $input['image'] = $main_image;
        }

        if ($request->hasFile('bg_image')) {
            $bg_image = time() . '.' . $bg_img->getClientOriginalExtension();
            $request->file('bg_image')->move(public_path('assets/front/img/sliders/bg_image/'), $bg_image);

                @unlink(public_path('assets/front/img/sliders/bg_image/' . $slider->bg_image));

            $input['bg_image'] = $bg_image;
        }




        $slider->update($input);
        Session::flash('success', 'Slider updated successfully!');
        return "success";
    }

    public function delete(Request $request)
    {

        $slider = Slider::findOrFail($request->slider_id);
        @unlink(public_path('assets/front/img/sliders/' . $slider->image));
        @unlink(public_path('assets/front/img/sliders/bg_image/' . $slider->bg_image));

        $slider->delete();

        Session::flash('success', 'Slider deleted successfully!');
        return back();
    }


    public function removeImage(Request $request) {
        $type = $request->type;
        $langid = $request->language_id;

        $be = BasicExtended::where('language_id', $langid)->firstOrFail();

        if ($type == "shape") {
            @unlink(public_path("assets/front/img/" . $be->slider_shape_img));
            $be->slider_shape_img = NULL;
            $be->save();
        }

        if ($type == "bottom") {
            @unlink(public_path("assets/front/img/" . $be->slider_bottom_img));
            $be->slider_bottom_img = NULL;
            $be->save();
        }

        $request->session()->flash('success', 'Image removed successfully!');
        return "success";
    }
}
